'PicoMite demo using Pico BackPack
'requires pre-configured SPI, I2C, LCD, touch, SD and audio as below

''OPTIONS:
'OPTION SYSTEM SPI GP18,GP19,GP16
'OPTION SDCARD GP21
'OPTION LCDPANEL ILI9488, LANDSCAPE,GP14,GP13,GP12
'GUI TEST LCDPANEL
'OPTION TOUCH GP15,GP17
'GUI CALIBRATE 0, 3941, 3894, -1274, -859
'GUI TEST TOUCH
'I2C needed for RTC
'OPTION SYSTEM I2C  GP10, GP11
'for audio
'OPTION AUDIO GP8, GP9
'to use GUI controls, eg
'OPTION GUI CONTROLS 20
'BACKLIGHT CONTROL is on pin GP20, IR Receiver on GP22

OPTION EXPLICIT
OPTION BASE 0
OPTION AUTORUN ON

'use RTC
RTC GETTIME

'to use IR
DIM INTEGER INT_DEVICE,INT_CODE
SETPIN GP22, IR  
IR INT_DEVICE,INT_CODE,IR_CHECK

DIM INTEGER IRTMOUT
IRTMOUT=TIMER-2000	''to update immediately

'Backlight GP20=PWM2A
SETPIN GP20, PWM
PWM 2,10000,100	'last number is duty in %

''Buttons for interface, using system GUI controls
DIM INTEGER BUTTON_COL,BUTTON_BACK	' for colour changes
CONST C.BUTTON=RGB(cyan)       		' button colour default
CONST C.B=RGB(BLACK)           		' background colour
CONST C.F=RGB(WHITE)           		' border colour
CONST C.GRAPH=RGB(GREEN)
BUTTON_COL=RGB(CYAN)  
BUTTON_BACK=RGB(64,64,64)

CLS
TEXT MM.HRES\2,0,"PICOMITE DRAW DEMO",CT,3,1,C.F,C.B

GUI BUTTON 1,"RED",   10,250,80, 40,BUTTON_COL,BUTTON_BACK
GUI BUTTON 2,"GREEN",110,250,80, 40,BUTTON_COL,BUTTON_BACK
GUI BUTTON 3,"BLUE", 210,250,80, 40,BUTTON_COL,BUTTON_BACK
GUI SPINBOX 4,310,250,160,40,BUTTON_COL,BUTTON_BACK,5,10,100
CTRLVAL(4)=100

DIM INTEGER X,Y,LASTX,LASTY, LASTBL, DRAWCOL,B1,B2,B3
LASTX=-1
LASTY=-1
LASTBL=100
DRAWCOL=RGB(WHITE)
B1=0
B2=0
B3=0

DO		''main
	TEXT MM.HRES\2,30,DATE$+" "+TIME$,CT,3,1,C.F,C.B		''show date and time
	IF (TIMER-IRTMOUT)>2000 THEN							''show blank IR messager after timeout
	  TEXT 10,MM.VRES-25,"IR:WAITING",LT,3,1,C.F,C.B
	  IRTMOUT=TIMER
	ENDIF
	IF (LASTBL <> CTRLVAL(4)) THEN							''change backlight if spinbox changed
		LASTBL = CTRLVAL(4)
		PWM 2,10000,LASTBL		
	ENDIF
	X=TOUCH(X)												''check touch and draw line
	Y=TOUCH(Y)
	IF (X>-1) AND (Y>-1) AND (LASTX>-1) AND (LASTY>-1) THEN
		LINE X,Y,LASTX,LASTY,1,DRAWCOL
	ENDIF	
	LASTX=X
	LASTY=Y
	IF (CTRLVAL(1)>0) THEN DRAWCOL=RGB(RED)
	IF (CTRLVAL(2)>0) THEN DRAWCOL=RGB(GREEN)
	IF (CTRLVAL(3)>0) THEN DRAWCOL=RGB(BLUE)
	IF (B1 <> CTRLVAL(1)) THEN
		B1=CTRLVAL(1)
		PLAY STOP
		IF B1=0 THEN PLAY TONE 400,400,200 
		IF B1<>0 THEN PLAY TONE 700,700,200 
	ENDIF
	IF (B2 <> CTRLVAL(2)) THEN
		B2=CTRLVAL(2)
		PLAY STOP
		IF B2=0 THEN PLAY TONE 400,400,200 
		IF B2<>0 THEN PLAY TONE 700,700,200 
	ENDIF
	IF (B3 <> CTRLVAL(3)) THEN
		B3=CTRLVAL(3)
		PLAY STOP
		IF B3=0 THEN PLAY TONE 400,400,200 
		IF B3<>0 THEN PLAY TONE 700,700,200 
	ENDIF		
LOOP	''main

SUB IR_CHECK
	PRINT "CODE:";INT_DEVICE;",DEVICE:";INT_CODE
	TEXT 10,MM.VRES-25,"IR:"+STR$(INT_DEVICE)+","+STR$(INT_CODE)+"      ",LT,3,1,C.F,C.B
	IRTMOUT=TIMER
END SUB

'the Ctrl-Z at the end of this file allows an AUTOSAVE transfer to automatically end

